//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Diagnostics;
using System.Collections;
using System.Text;
using System.Web.Mail;

namespace TraceSwitchTest
{
	/// <summary>
	/// Podsumowanie dla TraceSwitchMain.
	/// </summary>
	// W zalenoci od konfiguracji wyniki s zapisywane w:
	// trace.log
	// dzienniku zdarze
	// strumieniu wyjciowym debug
	// 
	class TraceSwitchMain
	{
		[Conditional("DEBUG")]
		static void WriteDebugOutput()
		{
			Console.WriteLine("To s informacje o debugowaniu");
		}

		public class CustomTraceListener : TraceListener
		{
			private Queue messageList;
			private StringBuilder message;
			private string mailTo;

			public CustomTraceListener(string to)
			{
				messageList = Queue.Synchronized(new Queue());
				mailTo = to;
			}
			public override void Close()
			{
				// Odbiornik zosta zamknity
				Flush();

				MailMessage mailMessage = new MailMessage();
				mailMessage.To = mailTo;
				mailMessage.Subject = "Wydruk ledzenia";
				mailMessage.BodyFormat = MailFormat.Text;

				while ( messageList.Count > 0 )
					mailMessage.Body += messageList.Dequeue() + "\r\n";

				mailMessage.Body += "\r\n";
				SmtpMail.Send(mailMessage);
			}
			public override void Flush()
			{
				// Odbiornik zosta oczyszczony
				if(message != null)
				{
					messageList.Enqueue(message);
					message = null;
				}
			}
			public override void Write(object o)
			{
				// Utworzenie wiadomoci
				if(message == null)
					message = new StringBuilder();
				message.Append(o.ToString());
			}
			public override void Write(string s)
			{
				// Utworzenie wiadomoci
				if(message == null)
					message = new StringBuilder();
				message.Append(s);
			}
			public override void Write(object o, string category)
			{
				// Utworzenie wiadomoci
				if(message == null)
					message = new StringBuilder();
				message.Append(category + ": " + o.ToString());
			}
			public override void Write(string s, string category)
			{
				// Utworzenie wiadomoci
				if(message == null)
					message = new StringBuilder();
				message.Append(category + ": " + s);
			}
			public override void WriteLine(object o)
			{
				Flush();
				// Zapisanie wiersza wiadomoci
				messageList.Enqueue(o.ToString());
			}
			public override void WriteLine(string s)
			{
				Flush();
				// Zapisanie wiersza wiadomoci
				messageList.Enqueue(s);
			}
			public override void WriteLine(object o, string s)
			{
				Flush();
				// Zapisanie wiersza wiadomoci
				messageList.Enqueue(o.ToString() + s);
			}
			public override void WriteLine(string s, string category)
			{
				Flush();
				// Zapisanie wiersza wiadomoci
				messageList.Enqueue(category + ": " + s);
			}
		}

		// Dostpne wartoci dla nowego przecznika.
		public enum CustomTracingSwitchLevel 
		{
			Off = 0,
			ShowStopper = 1,
			Critical = 2,
			Severe = 3,
			Annoying = 4,
			Success = 5
		}

		public class CustomTracingSwitch : Switch 
		{
			public CustomTracingSwitch(string displayName, string description) : base(displayName, description)
			{
			}
 			public bool ShowStopper
			{
				get
				{
					return SwitchSetting >= (int)CustomTracingSwitchLevel.ShowStopper;
				}
			}
			public bool Critical
			{
				get
				{
					return SwitchSetting >= (int)CustomTracingSwitchLevel.Critical;
				}
			}
			public bool Severe
			{
				get
				{
					return SwitchSetting >= (int)CustomTracingSwitchLevel.Severe;
				}
			}
			public bool Annoying
			{
				get
				{
					return SwitchSetting >= (int)CustomTracingSwitchLevel.Annoying;
				}
			}
			public bool Success
			{
				get
				{
					return SwitchSetting >= (int)CustomTracingSwitchLevel.Success;
				}
			}
		}

 	    static void Main(string[] args)
		{
			CustomTraceListener ctl = new CustomTraceListener("imie.nazwisko@mojafirma.com");
			Trace.Listeners.Add(ctl);

			TraceSwitch ts1 = new TraceSwitch("MySwitch", "Mj przecznik debugowania");
			TraceSwitch ts2 = new TraceSwitch("YourSwitch", "Twj przecznik debugowania");

			Trace.WriteLineIf(ts1.Level == TraceLevel.Info, "Moje wyniki");
			Trace.WriteLineIf(ts1.TraceError, "Mj komunikat o bdzie");
			Trace.WriteLineIf(ts1.TraceWarning, "Moje ostrzeenie");
			Trace.WriteLineIf(ts1.TraceInfo, "Moje informacje");

			Trace.WriteLineIf(ts2.Level == TraceLevel.Error, "Twoje wyniki");
			Trace.WriteLineIf(ts2.TraceError, "Twj komunikat o bdzie", "Kategoria");

			CustomTracingSwitch cs = new CustomTracingSwitch("CustomSwitch", "Wasny przecznik debugowania");
			Trace.WriteLineIf(cs.Annoying, "Wasny komunikat o bdzie", "Wasna kategoria");

			WriteDebugOutput();
			// Trace.Flush();
			Trace.Close();
		}
	}
}
